USE [PERF_BMS_VISTA]
	
	DECLARE @minSID int = 10, @resetSID int = 10, @maxPatients int = 1000
	DECLARE @tmp int

-- Discharge (from the facility where the pt was moved)
		
		--declare date ranges
		declare @dtDischargeINT datetime, @dtDischargeINT_Start datetime, @dtDischargeINT_End datetime
		declare @dtDischargeREQ datetime, @dtDischargeREQ_Start datetime, @dtDischargeREQ_End datetime
		declare @dtDischargeEVN datetime, @dtDischargeEVN_Start datetime, @dtDischargeEVN_End datetime

		set @dtDischargeINT_Start = '2012-05-26'
		set @dtDischargeINT_End = '2012-05-30'
		
		set @dtDischargeREQ_Start = '2012-05-31'
		set @dtDischargeREQ_End = '2012-06-02'
		
		set @dtDischargeEVN_Start = '2012-06-03'
		set @dtDischargeEVN_End = '2012-06-09'

		SELECT @dtDischargeINT = @dtDischargeINT_Start + (ABS( CAST(CAST( NewID() AS BINARY(8)) AS INT)) % CAST((@dtDischargeINT_End - @dtDischargeINT_Start) AS INT))
		 
	 WHILE @minSID < (@resetSID + @maxPatients/2) -- 10 < 510
		BEGIN
		INSERT INTO [dbo].[PATIENT_APPOINTMENT]
           ([APPOINTMENT_DATETIME]
           ,[HOSPITAL_LOCATION_ID]
           ,[HOSPITAL_LOCATION_TELEPHONE]
           ,[STATUS]
           ,[DATA_ENTRY_CLERK]
           ,[DATE_APPOINTMENT_MADE]
           ,[CURRENT_STATUS]
           ,[PATIENT_ID]
           ,INTERNAL_UID)
		 SELECT	
			@dtDischargeINT,
			WL.HOSPITAL_LOCATION_ID,
			null, null,
			@dtDischargeINT,
			@dtDischargeINT,
			'Active',
			P.IEN,
			newid()
		 FROM PATIENT_MOVEMENT PM inner join PATIENT P on PM.PATIENT_ID = P.IEN
			inner join WARD_LOCATION WL ON PM.WARD_LOCATION_ID = WL.IEN
		 WHERE P.NAME = 'PAT, TAP ' + cast(@minSID as varchar) and PM.TRANSACTION_= 1 -- admission --2 --movement
			
		-- Create discharge order
		
		SELECT @dtDischargeREQ = @dtDischargeREQ_Start +  (ABS(CAST(CAST( NewID() AS BINARY(8)) AS INT)) % CAST((@dtDischargeREQ_End - @dtDischargeREQ_Start) AS INT))
		
		INSERT INTO [dbo].[CPRS_ORDERS]
			   ([OBJECT_OF_ORDER]
			   ,[DATE_OF_LAST_ACTIVITY]
			   ,[ORDER_STATUS_ID]
			   ,[PATIENT_LOCATION_ID]
			   ,[ITEM_ORDERED]
			   ,[START_DATE]
			   ,[STOP_DATE]
			   ,[DC_DATE_TIME]
			   ,[TO_DISPLAY_GROUP_ID]
			   ,[ORDERABLE_ITEM_ID]
			   ,INTERNAL_UID)
		 SELECT 'PAT, TAP ' + cast(@minSID as varchar),
				@dtDischargeREQ,
				1,
				WL.HOSPITAL_LOCATION_ID,
				null,
				@dtDischargeREQ,
				null,
				null,
				null,
				1, --DISCHARGE				
				newid()
		 FROM PATIENT_MOVEMENT PM inner join PATIENT P on PM.PATIENT_ID = P.IEN
			inner join WARD_LOCATION WL ON PM.WARD_LOCATION_ID = WL.IEN
		 WHERE P.NAME = 'PAT, TAP ' + cast(@minSID as varchar) and PM.TRANSACTION_= 1 -- admission 2 --movement
		 
		 SET @tmp = SCOPE_IDENTITY()
		
		INSERT INTO [dbo].[CPRS_ORDERS_ORDERABLE_ITEM]
           ([CPRS_ORDERS_ID],[ORDERABLE_ITEM_ID])
         VALUES (@tmp, 1)	
			
		INSERT INTO [dbo].[ORDER_ACTIONS]
           ([DATE_TIME_ORDERED]
           ,[ORDER_TEXT]
           ,[SIGNATURE_STATUS]
           ,[DATE_TIME_SIGNED]
           ,[SIGNED_BY_ID]
           ,[NEW_PERSON_NAME]
           ,[PROVIDER_ID]
           ,[DATE_TIME_NURSE_VERIFIED]
           ,[VERIFYING_NURSE_ID]
           ,[DATE_TIME_CLERK_VERIFIED]
           ,[VERIFYING_CLERK_ID]
           ,[RELEASE_DATE_TIME]
           ,[RELEASE_STATUS]
           ,[CPRS_ORDER_ID])
		VALUES	
			(@dtDischargeREQ,
			'discharge',
			null,
			@dtDischargeREQ,
			 2,
			 null,
			 1,
			 null, null, null, null,
			 @dtDischargeREQ, null,
			 @tmp	
			)
		
		-- Create discharge event
		
		SELECT @dtDischargeEVN = @dtDischargeEVN_Start +  (ABS(CAST(CAST(NewID() AS BINARY(8)) AS INT)) % CAST((@dtDischargeEVN_End - @dtDischargeEVN_Start) AS INT))
		
		INSERT INTO [dbo].[PATIENT_MOVEMENT]
           ([DATETIME]
           ,[ENTERED_ON_DATETIME]
           ,[ENTERED_BY_ID]
           ,[TRANSACTION_ID]
           ,[MAS_MOVEMENT_TRANS_NAME]
           ,[PATIENT_ID]
           ,[TYPE_OF_MOVEMENT_ID]
           ,[FAC_MOVE_TYPE_NAME]
           ,[WARD_LOCATION_ID]
           ,[ROOM_BED_ID]
           ,[ADMISSION_CHECK_IN_MOVEMENT_ID]
           ,[RELATED_PHYSICAL_MOVEMENT_ID]
           ,[WARD_AT_DISCHARGE]
           ,[TRANSACTION_]
           ,INTERNAL_UID)
		SELECT
			@dtDischargeEVN,
			@dtDischargeEVN,
			2,
			null,null,
			P.IEN,
			1,
			null,
			PM.WARD_LOCATION_ID,
			PM.ROOM_BED_ID,
			null, null, null,
			3, -- Discharge
			newid()
		FROM PATIENT_MOVEMENT PM inner join PATIENT P on PM.PATIENT_ID = P.IEN
			inner join WARD_LOCATION WL ON PM.WARD_LOCATION_ID = WL.IEN
		WHERE P.NAME = 'PAT, TAP ' + cast(@minSID as varchar) and PM.TRANSACTION_= 1 -- admission  --2 --movement
		
 
		SET @minSID += 1 
		 
	END
	
	
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpHL') AND type in (N'U'))
		DROP TABLE tmpHL
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpWards') AND type in (N'U'))
		DROP TABLE tmpWards
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpBed') AND type in (N'U'))
		DROP TABLE tmpBed
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpPatient') AND type in (N'U'))
		DROP TABLE tmpPatient
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpMovementData') AND type in (N'U'))
		DROP TABLE tmpMovementData
	
	GO